/*
=========================================================
THE COMPUTER CODE CONTAINED HEREIN IS THE SOLE 
PROPERTY OF OUTRAGE ENTERTAINMENT, INC. 
('OUTRAGE').  OUTRAGE, IN DISTRIBUTING THE CODE TO
END-USERS, AND SUBJECT TO ALL OF THE TERMS AND 
CONDITIONS HEREIN, GRANTS A ROYALTY-FREE, 
PERPETUAL LICENSE TO SUCH END-USERS FOR USE BY 
SUCH END-USERS IN USING, DISPLAYING,  AND 
CREATING DERIVATIVE WORKS THEREOF, SO LONG AS
SUCH USE, DISPLAY OR CREATION IS FOR NON-
COMMERCIAL, ROYALTY OR REVENUE FREE PURPOSES. 
IN NO EVENT SHALL THE END-USER USE THE 
COMPUTER CODE CONTAINED HEREIN FOR REVENUE-
BEARING PURPOSES.  THE END-USER UNDERSTANDS
AND AGREES TO THE TERMS HEREIN AND ACCEPTS THE 
SAME BY USE OF THIS FILE.
COPYRIGHT 1999 OUTRAGE ENTERTAINMENT, INC.  ALL 
RIGHTS RESERVED.
=========================================================
*/

/*
 * Contains code that is common along all modules.  Mostly defines, flags, etc.
 *
 * 
 */

#ifndef __OSIRIS_COMMON_H_
#define __OSIRIS_COMMON_H_

#if defined(MACINTOSH)
#include "vecmat_external.h"
#include "aistruct_external.h"
#include "object_external.h"
#include "matcen_external.h"
#include "robotfirestruct_external.h"
#include "findintersection_external.h"
#include "weapon_external.h"
#include "damage_external.h"
#include "fireball_external.h"
#include "levelgoal_external.h"
#include "deathinfo_external.h"
#include "difficulty_external.h"
#include "gamecinematics_external.h"
#include "player_external.h"
#else
#include "../include/vecmat_external.h"
#include "../include/aistruct_external.h"
#include "../include/object_external.h"
#include "../include/matcen_external.h"
#include "../include/robotfirestruct_external.h"
#include "../include/findintersection_external.h"
#include "../include/weapon_external.h"
#include "../include/damage_external.h"
#include "../include/fireball_external.h"
#include "../include/levelgoal_external.h"
#include "../include/deathinfo_external.h"
#include "../include/difficulty_external.h"
#include "../include/gamecinematics_external.h"
#include "../include/player_external.h"
#endif

// =======================================================================
// Event return values (OR these if needed)
// =======================================================================
#define CONTINUE_CHAIN		0x0100	//continue executing the chain of scripts
#define CONTINUE_DEFAULT	0x0001	//continue executing the 'in-code' action

// =======================================================================
// Events that OSIRIS handles
// =======================================================================
#define EVT_INTERVAL					0x100		// called every frame
#define EVT_AI_FRAME					0x101		// called every frame for AI info
#define EVT_DAMAGED						0x102		// called when object is damaged
#define EVT_COLLIDE						0x103		// called when object collides with something
#define EVT_CREATED						0x104		// called when object created
#define EVT_DESTROY						0x105		// called when object destroyed
#define EVT_TIMER						0x106		// called when a timer event is signalled
#define EVT_USE							0x107		// called when item is selected for use from inventory
#define EVT_AI_NOTIFY					0x110		// called when an AI gets notified
#define EVT_AI_INIT						0x111		// called to initialize SCRIPT AI stuff
#define EVT_LEVELSTART					EVT_CREATED	// 
#define EVT_LEVELEND					EVT_DESTROY	// called when level is started and ended.
#define EVT_CHANGESEG					0x115		// called when object changes room
#define EVT_SAVESTATE					0x117		// called when the script should save it's state
#define EVT_RESTORESTATE				0x118		// called when the script should restore it's state
#define EVT_MEMRESTORE					0x119		// called when the script should restore a pointer to the special auto-save memory it allocated
#define EVT_TIMERCANCEL					0x11A		// called when a timer is cancels (either by function call or from it's object detonator)
#define EVT_AIN_OBJKILLED				0x11B		// child event of EVT_AI_NOTIFY
#define EVT_AIN_SEEPLAYER				0x11C		// child event of EVT_AI_NOTIFY
#define EVT_AIN_WHITOBJECT				0x11D		// child event of EVT_AI_NOTIFY
#define EVT_AIN_GOALCOMPLETE			0x11E		// child event of EVT_AI_NOTIFY
#define EVT_AIN_GOALFAIL				0x11F		// child event of EVT_AI_NOTIFY
#define EVT_AIN_MELEE_HIT				0x120		// child event of EVT_AI_NOTIFY
#define EVT_AIN_MELEE_ATTACK_FRAME		0x121		// child event of EVT_AI_NOTIFY
#define EVT_AIN_MOVIE_START				0x122		// child event of EVT_AI_NOTIFY
#define EVT_AIN_MOVIE_END				0x123		// child event of EVT_AI_NOTIFY
#define EVT_MATCEN_CREATE				0x124		// level event that a matcen created an object
#define EVT_DOOR_ACTIVATE				0x125		// event to when a door is opening
#define EVT_DOOR_CLOSE					0x126		// event to when a door is closing
#define EVT_CHILD_DIED					0x127
#define EVT_LEVEL_GOAL_COMPLETE		0x128
#define EVT_ALL_LEVEL_GOALS_COMPLETE 0x129
#define EVT_LEVEL_GOAL_ITEM_COMPLETE 0x12A
#define EVT_PLAYER_MOVIE_START			0x12B		// event when a IGC focusing on the player starts
#define EVT_PLAYER_MOVIE_END			0x12C		// event when a IGC focusing on the player ends
#define EVT_PLAYER_RESPAWN				0x12D		// event when a player respawns
#define EVT_PLAYER_DIES					0x12E		// event when a player dies


// =======================================================================
// General defines
// =======================================================================
#define MAX_MODULEFUNCS					256			// maximum number of functions imported to OSIRIS

typedef int OMMSHANDLE;

// =======================================================================
// Language defines
// =======================================================================
#define LANGUAGE_ENGLISH				0
#define LANGUAGE_GERMAN					1
#define LANGUAGE_SPANISH				2
#define LANGUAGE_ITALIAN				3
#define LANGUAGE_FRENCH					4
#define LANGUAGE_POLISH					5

// Player Accessories indices (for Player_Value function)
#define ACCESSORY_CLOAK					0
#define ACCESSORY_INVULNERABILITY	1
#define ACCESSORY_AFTERBURNER			2
#define ACCESSORY_HEADLIGHT			3
#define ACCESSORY_QUAD					4
#define ACCESSORY_RAPID_FIRE			5
#define ACCESSORY_MAP					6

#define MSAFE_ROOM		0
#define MSAFE_OBJ			20
#define MSAFE_WEATHER	100
#define MSAFE_SOUND		110
#define MSAFE_MATCEN		130
#define MSAFE_MISC		150
#define MSAFE_DOOR		170
#define MSAFE_MISSION	180
#define MSAFE_TRIGGER	190
#define MSAFE_INVEN		200
#define MSAFE_COUNTERMEASURE	210
#define MSAFE_WEAPON	250

#define	SPEW_RAND_SPEED		2
#define	SPEW_RAND_SIZE		4
#define	SPEW_RAND_LIFETIME	16

// =======================================================================
// Value Functions
// =======================================================================

#define VF_SET		     0
#define VF_GET		     1
#define VF_SET_FLAGS   2
#define VF_CLEAR_FLAGS 3

// =======================================================================
// Value - Player only values
// =======================================================================

#define PLYV_F_ENERGY						0
#define PLYV_F_MOVEMENT_SCALAR				1
#define PLYV_F_RECHARGE_SCALAR				2
#define PLYV_F_WSPEED_SCALAR				3
#define PLYV_F_DAMAGE_SCALAR				4
#define PLYV_F_ARMOR_SCALAR					5
#define PLYV_I_BUDDY_HANDLE					6

// These work off the weapon index
#define PLYSV_I_WEAPON						7
#define PLYSV_I_WEAPON_AMMO					8
#define PLYSV_US_WEAPON_POWERUP_ID			9

// These work off the accessory index
#define PLYSV_F_ACCESSORY					10

// This is for setting and getting the guidebot name
#define PLYV_CS_GUIDEBOTNAME				11

// this is for thief access
#define PLYV_B_THIEF_PLAYERHASITEM			12 //VF_GET only (takes a bool for ptr, int for index..which item..see THIEFITEM_)
#define PLYV_I_THIEF_STEALPLAYERITEM		13 //VF_SET only (takes an int for index, ptr is ignored)

#define PLYV_I_FLAGS								14 //Player flags
#define PLYV_I_STRIP_WEAPONS				15 //VF_SET only (removes all weapons but lasers, sets energy to 0)

//These are used to mask out various controls, put in initially for the training system
#define PLYV_CMASK_FORWARD			1
#define PLYV_CMASK_REVERSE			2
#define PLYV_CMASK_LEFT				4
#define PLYV_CMASK_RIGHT			8
#define PLYV_CMASK_UP				16
#define PLYV_CMASK_DOWN				32
#define PLYV_CMASK_PITCHUP			64
#define PLYV_CMASK_PITCHDOWN		128
#define PLYV_CMASK_HEADINGLEFT	256
#define PLYV_CMASK_HEADINGRIGHT	512
#define PLYV_CMASK_BANKLEFT		1024
#define PLYV_CMASK_BANKRIGHT		2048
#define PLYV_CMASK_PRIMARY			4096
#define PLYV_CMASK_SECONDARY		8192
#define PLYV_CMASK_AFTERBURNER	16384

// =======================================================================
// Value - AI Values
// =======================================================================

#define AIV_F_MAX_SPEED							0
#define AIV_F_MAX_DELTA_SPEED					1
#define AIV_F_MAX_TURN_RATE					2
#define AIV_F_MAX_DELTA_TURN_RATE			3
#define AIV_F_ATTACK_VEL_PERCENT				4
#define AIV_F_FLEE_VEL_PERCENT				5
#define AIV_F_DODGE_VEL_PERCENT				6
#define AIV_F_CIRCLE_DIST						7
#define AIV_F_DODGE_PERCENT					8
#define AIV_F_MELEE_DAMAGE1					9
#define AIV_F_MELEE_DAMAGE2					10
#define AIV_F_MELEE_LATENCY1					11
#define AIV_F_MELEE_LATENCY2					12
#define AIV_C_MOVEMENT_TYPE					13
#define AIV_C_MOVEMENT_SUBTYPE				14
#define AIV_C_ANIMATION_TYPE					15
#define AIV_C_NEXT_ANIMATION_TYPE			16
#define AIV_C_NEXT_MOVEMENT					17
#define AIV_C_CURRENT_WB_FIRING				18
#define AIV_I_TARGET_HANDLE					19
#define AIV_F_NEXT_TARGET_UPDATE_TIME		20
#define AIV_F_DIST_TO_TARGET					21
#define AIV_V_VEC_TO_TARGET					22
#define AIV_F_NEXT_CHECK_SEE_TARGET_TIME	23
#define AIV_V_LAST_SEE_TARGET_POS			24
#define AIV_F_LAST_SEE_TARGET_TIME			25
#define AIV_F_WEAPON_SPEED						26
#define AIV_F_NEXT_MELEE_TIME					27
#define AIV_F_LAST_RENDER_TIME				28
#define AIV_F_NEXT_FLINCH_TIME				29
#define AIV_V_MOVEMENT_DIR						30
#define AIV_V_ROT_THRUST_VECTOR				31
#define AIV_F_FOV									32
#define AIV_F_AVOID_FRIENDS_DIST				33
#define AIV_F_FRUSTRATION						34
#define AIV_F_CURIOUSITY						35
#define AIV_F_FIRE_SPREAD						36
#define AIV_F_AGRESSION							37
#define AIV_F_NIGHT_VISION						38
#define AIV_F_FOG_VISION						39
#define AIV_F_LEAD_ACCURACY					40
#define AIV_F_LEAD_VARIENCE					41
#define AIV_F_FIGHT_TEAM						42
#define AIV_F_FIGHT_SAME						43
#define AIV_F_HEARING							44
#define AIV_F_ROAMING							45
#define AIV_F_LIFE_PRESERVATION				46
#define AIV_F_BIASED_FLIGHT_IMPORTANCE		47
#define AIV_F_BIASED_FLIGHT_MIN				48
#define AIV_F_BIASED_FLIGHT_MAX				49
#define AIV_F_AWARENESS							50
#define AIV_I_FLAGS								51
#define AIV_I_STATUS_REG                  52
#define AIV_F_LAST_HEAR_TARGET_TIME			53

// =======================================================================
// Value - AI Values
// =======================================================================

#define AIGV_I_TYPE									0
#define AIGV_C_ACTIVATION_LEVEL					1
#define AIGV_F_MIN_INFLUENCE						2
#define AIGV_F_MAX_INFLUENCE						3

#define AIGSV_F_INFLUENCE_DIST					4

#define AIGV_I_HANDLE								5
#define AIGV_I_ROOMNUM								6
#define AIGV_I_F_ACTIONS							7
#define AIGV_I_ID										8
#define AIGV_C_SUBTYPE								9
#define AIGV_F_TIME									10
#define AIGV_V_VEC									11
#define AIGV_V_POS									12
#define AIGV_F_STEER_MIN_DIST						13
#define AIGV_F_STEER_MAX_DIST						14
#define AIGV_F_STEER_MAX_STRENGTH				15
#define AIGV_B_ATTACH_F_ALIGNED					16
#define AIGV_B_ATTACH_F_SPHERE					17
#define AIGV_F_ATTACH_RAD							18
#define AIGV_C_ATTACH_CHILD_AP					19
#define AIGV_C_ATTACH_PARENT_AP					20
#define AIGV_I_WANDER_AVOID_HANDLE				21
#define AIGV_C_WANDER_MIN_ROOMS					22
#define AIGV_C_WANDER_MAX_ROOMS					23
#define AIGV_C_WANDER_FLAGS						24
#define AIGV_C_WANDER_MINE_INDEX					25
#define AIGV_F_CIRCLE_DIST							26
#define AIGV_I_STATUS_REG							27
#define AIGV_F_START_TIME							28
#define AIGV_F_NEXT_PATH_TIME						29
#define AIGV_F_DIST_TO_GOAL						30
#define AIGV_V_VEC_TO_TARGET						31
#define AIGV_F_NEXT_CHECK_SEE_TARGET_TIME		32
#define AIGV_V_LAST_SEE_TARGET_POS				33
#define AIGV_F_LAST_SEE_TARGET_TIME				34
#define AIGV_F_NEXT_TARGET_UPDATE_TIME			35
#define AIGV_I_FLAGS									36
#define AIGV_V_ORIENT_FVEC							37
#define AIGV_V_ORIENT_UVEC							38

#define AIGV_C_NUM_ENABLERS						39
#define AIGSV_C_ENABLER_TYPE						40
#define AIGSV_F_ENABLER_TIME						41
#define AIGSV_C_ENABLER_MTYPE						42
#define AIGSV_F_ENABLER_FLOAT_VALUE				43
#define AIGSV_I_ENABLER_FLAGS						44
#define AIGSV_F_ENABLER_DIST						45
#define AIGSV_F_ENABLER_PERCENT					46
#define AIGSV_F_ENABLER_CHECK_INTERVAL			47
#define AIGSV_F_ENABLER_LAST_CHECK_TIME		48
#define AIGSV_C_ENABLER_NEXT_ENABLER_OP		49

#define AIGV_B_USED									50
#define AIGV_I_SCRIPTED_DATA_PTR					51

// =======================================================================
// Value - Object Values
// =======================================================================

#define OBJV_F_SHIELDS							0
#define OBJV_I_TYPE								1
#define OBJV_US_ID								2
#define OBJV_V_POS								3
#define OBJV_M_ORIENT							4
#define OBJV_I_ROOMNUM							5
#define OBJV_V_VELOCITY							6
#define OBJV_V_ROTVELOCITY						7
#define OBJV_V_THRUST							8
#define OBJV_V_ROTTHRUST						9
#define OBJV_I_FLAGS								10
#define OBJV_F_SIZE								11
#define OBJV_C_CONTROL_TYPE					12
#define OBJV_C_MOVEMENT_TYPE					13
#define OBJV_F_CREATION_TIME					14
#define OBJV_F_ROTDRAG							15
#define OBJV_I_PHYSICS_FLAGS					16
#define OBJV_I_PARENT_HANDLE					17
#define OBJV_F_ANIM_FRAME						18
#define OBJV_F_MAX_SHIELDS                19
#define OBJV_PC_MARKER_MESSAGE				20
#define OBJSV_F_ANIM_START						21
#define OBJSV_F_ANIM_END						22
#define OBJSV_F_ANIM_TIME						23
#define OBJV_S_NAME								24		// object's name
#define OBJV_C_VIRUS_INFECTED					25		// the object show signs of virus infection
#define OBJV_C_NEGATIVE_LIGHT					26		// the object casts negative light (black hole)
#define OBJV_C_IS_CLOAKED						27		// is object cloaked?
#define OBJV_PI_HACK_FVI_IGNORE_LIST      28

// =======================================================================
// Value - Object Weapon Battery Values
// =======================================================================

#define WBV_F_ANIM_FRAME						0
#define WBV_F_LAST_FIRE_TIME					1
#define WBV_I_DYNAMIC_FLAGS					2

//WBSV values use the index parameter of Obj_WBValue() for the gun point index
#define WBV_C_NUM_GUNPTS						3
#define WBSV_US_GUNPT_WEAPON_ID			   4
#define WBSV_V_GUNPT_POS						5

//WBSV values use the index parameter of Obj_WBValue() for the firing mask index
#define WBV_C_NUM_MASKS							6
#define WBSV_C_MASK								7
#define WBSV_I_FIRE_SOUND						8
#define WBSV_F_LATENCY							9
#define WBSV_F_ANIM_TIME						10
#define WBSV_F_ANIM_START						11
#define WBSV_F_ANIM_FIRE						12
#define WBSV_F_ANIM_END							13

#define WBV_C_NUM_WBS							14

// =======================================================================
// Value - Room Values
// =======================================================================

#define RMV_I_FLAGS							0
#define RMV_V_WIND							1
#define RMV_C_USED							2

#define RMV_I_NUM_PATH_PNTS				3
#define RMSV_V_PATH_PNT						4

#define RMV_I_NUM_FACES						5
#define RMSV_I_FACE_TEXTURE_ID			6
#define RMSV_I_FACE_FLAGS					7
#define RMSV_V_FACE_NORMAL					8
#define RMSV_V_FACE_CENTER_PNT			14  // I didn't want to reorder the other ones as it is late in the build process

#define RMV_I_NUM_PORTALS					9
#define RMSV_V_PORTAL_PATH_PNT			10
#define RMSV_I_PORTAL_CONNECT_ROOM		11
#define RMSV_I_PORTAL_CONNECT_PORTAL	12
#define RMSV_I_PORTAL_FACE					13
#define RMSV_I_PORTAL_FLAGS				15

#define RMV_F_DAMAGE							16

// =======================================================================
// Value - Level Goal Values
// =======================================================================

#define LGV_I_STATUS								0

#define LGV_I_NUM_ACTIVE_PRIMARIES			1
#define LGSV_I_ACTIVE_PRIMARY_GOAL			2
	
#define LGV_I_NUM_ACTIVE_SECONDARIES		3
#define LGSV_I_ACTIVE_SECONDARY_GOAL		4

#define LGV_I_NUM_GOALS							5
#define LGSV_PC_GOAL_NAME						6
#define LGSV_PC_LOCATION_NAME					7
#define LGSV_PC_DESCRIPTION					8
#define LGSV_PC_COMPLETION_MESSAGE			9
#define LGSV_I_PRIORITY							10
#define LGSV_C_GOAL_LIST						11
#define LGSV_I_STATUS							12

#define LGSV_I_NUM_ITEMS						13
#define LGSSV_C_ITEM_TYPE						14
#define LGSSV_I_ITEM_HANDLE					15
#define LGSSV_B_ITEM_DONE						16

// =======================================================================
// Value - Matcen Values
// =======================================================================

#define MTNV_C_ATTACH_TYPE					0
#define MTNV_C_CONTROL_TYPE				1
#define MTNV_I_ATTACH						2
#define MTNV_V_CREATE_POINT				3
#define MTNV_I_CREATE_ROOM					4
#define MTNV_PC_NAME							5
#define MTNV_I_MAX_PROD						6
#define MTNV_F_PROD_MULTIPLIER			7
#define MTNV_I_STATUS						8
#define MTNV_C_CREATION_EFFECT			9
#define MTNV_I_MAX_ALIVE_CHILDREN		10
#define MTNV_F_PRE_PROD_TIME				11
#define MTNV_F_POST_PROD_TIME				12
#define MTNV_S_CREATION_TEXTURE			13

#define MTNSV_I_SOUND						14

#define MTNV_C_NUM_SPAWN_PTS				15
#define MTNSV_I_SPAWN_POINT				16

#define MTNV_C_NUM_PROD_TYPES				17
#define MTNSV_I_PROD_ITEM_ID				18
#define MTNSV_I_PROD_ITEM_PRIORITY		19
#define MTNSV_F_PROD_ITEM_TIME			20
#define MTNSV_I_PROD_ITEM_MAX_PROD		21

// =======================================================================
// inventory add flags
// =======================================================================
#define INVAF_NOTSPEWABLE	0x0001
#define INVAF_TIMEOUTONSPEW	0x0002
#define INVAF_LEVELLAST		0x0004

// =======================================================================
// thief stealable items (see PLYV_ actions)
// =======================================================================
#define THIEFITEM_AUTOMAP	1
#define THIEFITEM_HEADLIGHT	2
#define THIEFITEM_ETOSCONV	3
#define THIEFITEM_CLOAK		4
#define THIEFITEM_INVULN	5
#define THIEFITEM_RAPIDFIRE	6
#define THIEFITEM_QUADFIRE	7
#define THIEFITEM_MAXCOUNT	8


// =======================================================================
// Multiplayer safe function type defines
// =======================================================================

#define MSAFE_ROOM_TEXTURE				MSAFE_ROOM+0
#define MSAFE_ROOM_WIND					MSAFE_ROOM+1
#define MSAFE_ROOM_FOG					MSAFE_ROOM+2
#define MSAFE_ROOM_LIGHT_PULSE 		MSAFE_ROOM+3
#define MSAFE_ROOM_PORTAL_RENDER		MSAFE_ROOM+4
#define MSAFE_ROOM_FOG_STATE			MSAFE_ROOM+5
#define MSAFE_ROOM_CHANGING_FOG		MSAFE_ROOM+6
#define MSAFE_ROOM_CHANGING_WIND		MSAFE_ROOM+7
#define MSAFE_ROOM_DAMAGE				MSAFE_ROOM+8
#define MSAFE_ROOM_LIGHT_FLICKER		MSAFE_ROOM+9
#define MSAFE_ROOM_LIGHT_STROBE		MSAFE_ROOM+10
#define MSAFE_ROOM_REFUEL				MSAFE_ROOM+11
#define MSAFE_ROOM_HAS_PLAYER			MSAFE_ROOM+12
#define MSAFE_ROOM_BREAK_GLASS		MSAFE_ROOM+13
#define MSAFE_ROOM_PORTAL_BLOCK     MSAFE_ROOM+14
#define MSAFE_ROOM_REMOVE_ALL_POWERUPS	MSAFE_ROOM+15

#define MSAFE_OBJECT_SHIELDS				MSAFE_OBJ+0
#define MSAFE_OBJECT_ENERGY				MSAFE_OBJ+1
#define MSAFE_OBJECT_BLANK					MSAFE_OBJ+2
#define MSAFE_OBJECT_LIGHT_COLOR			MSAFE_OBJ+3
#define MSAFE_OBJECT_MOVEMENT_SCALAR	MSAFE_OBJ+4
#define MSAFE_OBJECT_RECHARGE_SCALAR	MSAFE_OBJ+5
#define MSAFE_OBJECT_WSPEED_SCALAR		MSAFE_OBJ+6
#define MSAFE_OBJECT_DAMAGE_SCALAR		MSAFE_OBJ+7
#define MSAFE_OBJECT_ARMOR_SCALAR		MSAFE_OBJ+8
#define MSAFE_OBJECT_DAMAGE_OBJECT		MSAFE_OBJ+9
#define MSAFE_OBJECT_TYPE					MSAFE_OBJ+10
#define MSAFE_OBJECT_ID						MSAFE_OBJ+11
#define MSAFE_OBJECT_ADD_WEAPON			MSAFE_OBJ+12
#define MSAFE_OBJECT_START_SPEW			MSAFE_OBJ+13
#define MSAFE_OBJECT_STOP_SPEW			MSAFE_OBJ+14
#define MSAFE_OBJECT_GHOST					MSAFE_OBJ+15
#define MSAFE_OBJECT_UNGHOST				MSAFE_OBJ+16
#define MSAFE_OBJECT_REMOVE				MSAFE_OBJ+17
#define MSAFE_OBJECT_POS					MSAFE_OBJ+18
#define MSAFE_OBJECT_ORIENT				MSAFE_OBJ+19
#define MSAFE_OBJECT_ROOMNUM				MSAFE_OBJ+20
#define MSAFE_OBJECT_VELOCITY				MSAFE_OBJ+21
#define MSAFE_OBJECT_ROTVELOCITY			MSAFE_OBJ+22
#define MSAFE_OBJECT_THRUST				MSAFE_OBJ+23
#define MSAFE_OBJECT_ROTTHRUST			MSAFE_OBJ+24
#define MSAFE_OBJECT_FLAGS					MSAFE_OBJ+25
#define MSAFE_OBJECT_SIZE					MSAFE_OBJ+26
#define MSAFE_OBJECT_CONTROL_TYPE		MSAFE_OBJ+27
#define MSAFE_OBJECT_MOVEMENT_TYPE		MSAFE_OBJ+28
#define MSAFE_OBJECT_CREATION_TIME		MSAFE_OBJ+29
#define MSAFE_OBJECT_CLOAKALLPLAYERS		MSAFE_OBJ+30
#define MSAFE_OBJECT_PHYSICS_FLAGS		MSAFE_OBJ+31
#define MSAFE_OBJECT_PARENT            MSAFE_OBJ+32
#define MSAFE_OBJECT_ROTDRAG				MSAFE_OBJ+33
#define MSAFE_OBJECT_INVULNERABLE		MSAFE_OBJ+34
#define MSAFE_OBJECT_CLOAK					MSAFE_OBJ+35
#define MSAFE_OBJECT_PLAYER_HANDLE		MSAFE_OBJ+36
#define MSAFE_OBJECT_PLAYER_CMASK		MSAFE_OBJ+37
#define MSAFE_OBJECT_NO_RENDER			MSAFE_OBJ+38
#define MSAFE_OBJECT_LIGHT_DIST	 		MSAFE_OBJ+39
#define MSAFE_OBJECT_DEFORM		 		MSAFE_OBJ+40
#define MSAFE_OBJECT_VIEWER_SHAKE 		MSAFE_OBJ+41		//or is this player shake?
#define MSAFE_OBJECT_PLAYER_KEY			MSAFE_OBJ+42
#define MSAFE_OBJECT_PLAYER_CONTROLAI	MSAFE_OBJ+43
#define MSAFE_OBJECT_WORLD_POSITION		MSAFE_OBJ+44		//room+pos+orient
#define MSAFE_OBJECT_COUNT_TYPE			MSAFE_OBJ+45
#define MSAFE_OBJECT_SPARKS		 		MSAFE_OBJ+46
#define MSAFE_OBJECT_SETONFIRE			MSAFE_OBJ+47		//objhandle, longevity = how long, interval = damage per sec, ithandle = killer (or OBJECT_HANDLE_NONE)
#define MSAFE_OBJECT_SHAKE_AREA	 		MSAFE_OBJ+48
#define MSAFE_OBJECT_ENERGY_WEAPON		MSAFE_OBJ+49
#define MSAFE_OBJECT_DAMAGE_AMOUNT		MSAFE_OBJ+50
#define MSAFE_OBJECT_SHIELDS_ORIGINAL	MSAFE_OBJ+51
#define MSAFE_SHOW_ENABLED_CONTROLS		MSAFE_OBJ+52
#define MSAFE_OBJECT_FIRE_WEAPON			MSAFE_OBJ+53
#define MSAFE_OBJECT_DESTROY_ROBOTS_EXCEPT	MSAFE_OBJ+54


#define MSAFE_WEATHER_RAIN			MSAFE_WEATHER+0
#define MSAFE_WEATHER_SNOW			MSAFE_WEATHER+1
#define MSAFE_WEATHER_LIGHTNING	MSAFE_WEATHER+2
#define MSAFE_WEATHER_LIGHTNING_BOLT MSAFE_WEATHER+3
#define MSAFE_WEATHER_LIGHTNING_BOLT_POS MSAFE_WEATHER+4

#define MSAFE_SOUND_2D				MSAFE_SOUND+0
#define MSAFE_SOUND_OBJECT			MSAFE_SOUND+1
#define MSAFE_SOUND_STREAMING		MSAFE_SOUND+2
#define MSAFE_SOUND_STOP			MSAFE_SOUND+3
#define MSAFE_SOUND_STOP_OBJ		MSAFE_SOUND+4
#define MSAFE_SOUND_VOLUME_OBJ	MSAFE_SOUND+5

#define MSAFE_DOOR_LOCK_STATE		MSAFE_DOOR+0
#define MSAFE_DOOR_ACTIVATE		MSAFE_DOOR+1
#define MSAFE_DOOR_POSITION		MSAFE_DOOR+2
#define MSAFE_DOOR_STOP				MSAFE_DOOR+3
#define MSAFE_DOOR_OPENABLE		MSAFE_DOOR+4

#define MSAFE_TRIGGER_SET			MSAFE_TRIGGER+0

#define MSAFE_MISC_HUD_MESSAGE	MSAFE_MISC+0
#define MSAFE_MISC_WAYPOINT		MSAFE_MISC+1
#define MSAFE_MISC_END_LEVEL		MSAFE_MISC+2
#define MSAFE_MISC_POPUP_CAMERA	MSAFE_MISC+3
#define MSAFE_MISC_CLOSE_POPUP	MSAFE_MISC+4
#define MSAFE_MISC_GAME_MESSAGE	MSAFE_MISC+5
#define MSAFE_MUSIC_REGION			MSAFE_MISC+6
#define MSAFE_MISC_ENABLE_SHIP		MSAFE_MISC+7
#define MSAFE_MISC_LEVELGOAL		MSAFE_MISC+8
#define MSAFE_MISC_GUIDEBOT_NAME	MSAFE_MISC+9
#define MSAFE_MISC_FILTERED_HUD_MESSAGE MSAFE_MISC+10
#define MSAFE_MISC_START_TIMER	MSAFE_MISC+11
#define MSAFE_MISC_ADD_HUD_ITEM	MSAFE_MISC+12
#define MSAFE_MISC_UPDATE_HUD_ITEM	MSAFE_MISC+13

#define MSAFE_INVEN_ADD_TYPE_ID		MSAFE_INVEN+0
#define MSAFE_INVEN_CHECK			MSAFE_INVEN+1
#define MSAFE_INVEN_COUNT			MSAFE_INVEN+2
#define MSAFE_INVEN_REMOVE			MSAFE_INVEN+3
#define MSAFE_INVEN_SIZE			MSAFE_INVEN+4
#define MSAFE_INVEN_GET_TYPE_ID		MSAFE_INVEN+5
#define MSAFE_INVEN_ADD_OBJECT		MSAFE_INVEN+6
#define MSAFE_INVEN_CHECK_OBJECT	MSAFE_INVEN+7
#define MSAFE_INVEN_REMOVE_OBJECT	MSAFE_INVEN+8

#define MSAFE_COUNTERMEASURE_ADD		MSAFE_COUNTERMEASURE+0
#define MSAFE_COUNTERMEASURE_COUNT		MSAFE_COUNTERMEASURE+1
#define MSAFE_COUNTERMEASURE_CHECK		MSAFE_COUNTERMEASURE+2
#define MSAFE_COUNTERMEASURE_REMOVE		MSAFE_COUNTERMEASURE+3
#define MSAFE_COUNTERMEASURE_SIZE		MSAFE_COUNTERMEASURE+4
#define MSAFE_COUNTERMEASURE_GET		MSAFE_COUNTERMEASURE+5

#define MSAFE_WEAPON_CHECK			MSAFE_WEAPON+0
#define MSAFE_WEAPON_ADD			MSAFE_WEAPON+1

// =======================================================================
// Structures shared between OSIRIS and the game
// =======================================================================

// Since this header is shared within D3, in order to keep redefinition errors
// quiet, the following section will only be included if this header file 
// is included by a DLL
#ifndef INCLUDED_FROM_D3

//Use this handle when you want a handle that will never be a valid object
#ifndef INCLUDED_FROM_PLAYER_H
#define MAX_PLAYERS					32
#endif

//define unsigned types;
typedef unsigned char ubyte;
typedef signed char sbyte;
typedef unsigned short ushort;
typedef unsigned int uint;
typedef unsigned long ulong;
typedef unsigned int ddgr_color;

#ifndef NULL
#define NULL 0
#endif

inline ddgr_color GR_RGB(int r, int g, int b)
{
	return ((r << 16) + (g << 8) + b);
}

#endif	//end #ifndef INCLUDED_FROM_D3


// =======================================================================
// GB Menu structure
// =======================================================================

#define MAX_GB_COMMANDS 60

#define GBCT_EXIT_IMMEDIATELY 0
#define GBCT_STRING_DIALOG		1

#define COM_GET_MENU		    0
#define COM_DO_ACTION       1
#define COM_REINIT			 2

typedef struct
{
	char action;
	char index;
	void *ptr;
} gb_com;

typedef struct
{
	char title[256];
	int num_commands;
	char command_text[MAX_GB_COMMANDS][256];
	char command_id[MAX_GB_COMMANDS];
	char command_type[MAX_GB_COMMANDS];

	char dialog_text[MAX_GB_COMMANDS][256];
} gb_menu;

// =======================================================================
//  Osiris structures
// =======================================================================


typedef struct{
	int *fp[MAX_MODULEFUNCS];
	char **string_table;
	int string_count;
	int module_identifier;
	
	bool module_is_static;							// if this is set to true after initialization
													// then the module will not unload if it's reference
													// count is 0....only when the level ends.
													// this is for Game modules ONLY.
	
	char *script_identifier;						// Contains a unique script identifier (string), which
													// can be used for the OMMS system. While this pointer
													// will always be valid during the lifetime of the module
													// DO NOT ALTER THE STRING IT POINTS TO.

	uint game_checksum;								// Checksum of game structures, if this doesn't match
													// the checksum at compile time, it is very likely that
													// bad things can happen, and this module shouldn't initialize.

}tOSIRISModuleInit;									// contains the necessary data to initialize

													// an OSIRIS module
typedef struct{
	float frame_time;
	float game_time;
}tOSIRISEVTINTERVAL;								// struct for EVT_INTERVAL data

typedef struct{
}tOSIRISIEVTAIFRAME;								// struct for EVT_AI_FRAME data

typedef struct{
	float damage;
	int it_handle;
	int weapon_handle;
	int damage_type;
}tOSIRISEVTDAMAGED;									// struct for EVT_DAMAGED data

typedef struct{
	int it_handle;
}tOSIRISEVTCOLLIDE;									// struct for EVT_COLLIDE data

typedef struct{
}tOSIRISEVTCREATED;									// struct for EVT_CREATED data

typedef struct{
	ubyte is_dying;	//if this is !=0 than the event is coming because it is
					//really being destroyed.  Else it is due to the level ending.
}tOSIRISEVTDESTROY;									// struct for EVT_DESTROY data

typedef struct{
	int id;
	float game_time;
}tOSIRISEVTTIMER;									// struct for EVT_TIMER data

typedef struct{
	int it_handle;
}tOSIRISEVTUSE;										// struct for EVT_USE data

typedef struct{
	void *fileptr;
}tOSIRISEVTSAVESTATE;								// struct for EVT_SAVESTATE data

typedef struct{
	void *fileptr;
}tOSIRISEVTRESTORESTATE;							// struct for EVT_RESTORESTATE data

typedef struct{
	int notify_type;
	int it_handle;
	int goal_num;
	int goal_uid;
	union{
		int enabler_num;
		int attack_num;
	};	
}tOSIRISEVTAINOTIFY;								// struct for EVT_AI_NOTIFY data

typedef struct{
}tOSIRISEVTAIINIT;									// struct for EVT_AI_INIT data

typedef struct{
}tOSIRISEVTLEVELSTART;								// struct for EVT_LEVELSTART data

typedef struct{
}tOSIRISEVTLEVELEND;								// struct for EVT_LEVELEND data

typedef struct{
	int room_num;
}tOSIRISEVTCHANGESEG;								// struct for EVT_CHANGESEG data

typedef struct{
	int id;
	void *memory_ptr;
}tOSIRISEVTMEMRESTORE;								// struct for EVT_MEMRESTORE data

typedef struct{
	int handle;
	ubyte detonated;
}tOSIRISEVTTIMERCANCEL;								// struct for EVT_TIMERCANCEL data

typedef struct{
	int it_handle;
}tOSIRISEVTCHILDDIED;

typedef struct{
	int it_handle;
	int id;
}tOSIRISEVTMATCENCREATE;							// struct for EVT_MATCEN_CREATE data

typedef struct{
}tOSIRISEVTDOORACTIVATE;							// struct for EVT_DOOR_ACTIVATE data

typedef struct{
}tOSIRISEVTDOORCLOSE;								// struct for EVT_DOOR_CLOSE data

typedef struct{
	int level_goal_index;
}tOSIRISEVTLEVELGOALCOMPLETE;

typedef struct{
	int level_goal_index;
}tOSIRISEVTLEVELGOALITEMCOMPLETE;

typedef struct{
} tOSIRISEVTALLLEVELGOALSCOMPLETE;

typedef struct{
} tOSIRISEVTPLAYERMOVIESTART;

typedef struct{
} tOSIRISEVTPLAYERMOVIEEND;

typedef struct{	
	int it_handle;	//player respawning
} tOSIRISEVTPLAYERRESPAWN;

typedef struct{
	int it_handle;	//player dead
} tOSIRISEVTPLAYERDIES;

typedef struct{
	union{
		tOSIRISEVTINTERVAL		evt_interval;
		tOSIRISIEVTAIFRAME		evt_ai_frame;
		tOSIRISEVTDAMAGED		evt_damaged;
		tOSIRISEVTCOLLIDE		evt_collide;
		tOSIRISEVTCREATED		evt_created;
		tOSIRISEVTDESTROY		evt_destroy;
		tOSIRISEVTTIMER			evt_timer;
		tOSIRISEVTUSE			evt_use;
		tOSIRISEVTAINOTIFY		evt_ai_notify;
		tOSIRISEVTAINOTIFY		evt_ain_objkilled;
		tOSIRISEVTAINOTIFY		evt_ain_seeplayer;
		tOSIRISEVTAINOTIFY		evt_ain_whitobject;
		tOSIRISEVTAINOTIFY		evt_ain_goalcomplete;
		tOSIRISEVTAINOTIFY		evt_ain_goalinvalid;
		tOSIRISEVTAINOTIFY		evt_ain_goalfail;
		tOSIRISEVTAINOTIFY		evt_ain_goalerror;
		tOSIRISEVTAINOTIFY		evt_ain_goalforcedone;
		tOSIRISEVTAINOTIFY		evt_ain_melee_hit;
		tOSIRISEVTAINOTIFY		evt_ain_melee_attack_frame;
		tOSIRISEVTAINOTIFY		evt_ain_movie_start;
		tOSIRISEVTAINOTIFY		evt_ain_movie_end;		
		tOSIRISEVTAIINIT		evt_ai_init;
		tOSIRISEVTLEVELSTART	evt_levelstart;
		tOSIRISEVTLEVELEND		evt_levelend;
		tOSIRISEVTCHANGESEG		evt_changeseg;
		tOSIRISEVTSAVESTATE		evt_savestate;
		tOSIRISEVTRESTORESTATE	evt_restorestate;
		tOSIRISEVTMEMRESTORE	evt_memrestore;
		tOSIRISEVTTIMERCANCEL	evt_timercancel;
		tOSIRISEVTMATCENCREATE	evt_matcen_create;
		tOSIRISEVTDOORACTIVATE	evt_door_activate;
		tOSIRISEVTDOORCLOSE		evt_door_close;
		tOSIRISEVTCHILDDIED     evt_child_died;
		tOSIRISEVTLEVELGOALCOMPLETE	evt_level_goal_complete;
		tOSIRISEVTALLLEVELGOALSCOMPLETE evt_all_level_goals_complete;
		tOSIRISEVTLEVELGOALITEMCOMPLETE	evt_level_goal_item_complete;
		tOSIRISEVTPLAYERMOVIESTART	evt_player_movie_start;
		tOSIRISEVTPLAYERMOVIEEND	evt_player_movie_end;
		tOSIRISEVTPLAYERRESPAWN		evt_player_respawn;
		tOSIRISEVTPLAYERDIES		evt_player_dies;
	};

	int me_handle;
	void *extra_info;
}tOSIRISEventInfo;									// contains the necessary data for all events
													// to pass what they need to their event handlers.

#define OTF_REPEATER	0x0001	//this timer is to repeat repeat_count times
#define OTF_TRIGGER		0x0002	//this timer is for a trigger, use trigger_number
#define OTF_LEVEL		0x0004	//this timer is for the level
#define OTF_CANCELONDEAD 0x008	//this timer should be auto-cancelled if object_handle_detonator dies, than the
								//timer auto-cancels
typedef struct{
	ushort flags;
	int id;					//an optional id you can use to store, will be passed back on EVT_TIMER signal
	int repeat_count;		//if OTF_REPEATER is set, this is how many times to repeat the signal (every
							//interval).  -1 for infinite.
	union{
		int object_handle;	//handle to the object to recieve the EVT_TIMER signal
		int trigger_number;	//trigger number to recieve the EVT_TIMER signal (OTF_TRIGGER)
	};

	int object_handle_detonator;	//if OTF_CANCELONDEAD is specified, this is the object handle to
									//use for checking, if this object dies, than auto-cancel the timer

	float timer_interval;	//the timeframe in between EVT_TIMER signals (for non-repeaters, this is how
							//long until the single EVT_TIMER gets signaled).
}tOSIRISTIMER;

typedef enum{
	OBJECT_SCRIPT=0,TRIGGER_SCRIPT,LEVEL_SCRIPT
}script_type;

typedef struct{
	script_type type;
	union{
		int objhandle;
		int triggernum;
	};
}tOSIRISSCRIPTID;

typedef struct{
	tOSIRISSCRIPTID my_id;
	ushort id;
	int size;
}tOSIRISMEMCHUNK;

// =======================================================================
// Multiplayer safe function structs
// =======================================================================

#define KOI_ID		0	//this item is specifying a type/id of object NOT to kill
#define KOI_HANDLE	1	//this item is specifying an object handle of an object NOT to kill
typedef struct
{
	ubyte info_type;
	int id;
	int objhandle;
}tKillObjectItem;

#define MSAFE_MESSAGE_LENGTH	255
#define MSAFE_NAME_LENGTH		32
typedef struct
{
	// Rooms
	int roomnum;
	short facenum;
	short texnum;
	short portalnum;
	float fog_r,fog_g,fog_b,fog_depth;
	vector wind;
	ubyte pulse_time;
	ubyte pulse_offset;

	// Objects/Players
	uint objhandle;
	uint ithandle;
	float shields,energy;
	short start_tick;
	short end_tick;
	float cycle_time;
	int type,id,aux_type,aux_id;
	uint checksum;
	int path_id;
	float amount;
	ubyte damage_type;
	uint killer_handle;
	float ammo;
	ubyte playsound;
	ubyte remove;
	ubyte do_powerup;
	vector velocity;
	vector rot_velocity;
	float rot_drag;
	vector thrust;
	vector rot_thrust;
	char control_type;
	char movement_type;
	float creation_time;
	int physics_flags;
	vector pos;
	matrix orient;
	float anim_frame;

	// Spew
	ubyte is_real;
	ubyte random;
	ubyte unused2;		//was use_gunpoint
	sbyte gunpoint;
	ubyte effect_type;
	ubyte phys_info;
	float drag,mass;

	// Unused
	ushort unused;		//was doorway_index

	// Weather
	int randval;

	// Triggers
	ubyte trigger_num;

	// sounds
	int sound_handle;
	float volume;

	// Shared/misc
	int index;
	float scalar;
	float interval;
	ubyte	state;
	sbyte	slot;
	char message[MSAFE_MESSAGE_LENGTH];
	char name[MSAFE_NAME_LENGTH];
	int color;
	float longevity;
	float lifetime;
	float size;
	float speed;
	int count;
	int flags;
	void *list;
	unsigned int control_mask;
	unsigned char control_val;

	//Object lighting stuff
	float light_distance;
	float r1,g1,b1;			//light 1 color
	float r2,g2,b2;			//light 2 color
	float time_interval;
	float	flicker_distance;
	float directional_dot;
	int timebits;

	vector pos2;

	//Second message
	char message2[MSAFE_MESSAGE_LENGTH];

} msafe_struct;

typedef struct{
	int fate;
	int hit_room;
	vector hit_point;

	int hit_object;
	int hit_subobject;

	int hit_face;
	vector hit_face_pnt;
	int hit_face_room;
	vector hit_wallnorm;
}ray_info;

#define PV_POS			0x00000001	// set/get pos member (pass in an osiris_path_node_info ptr)
#define PV_ROOMNUM		0x00000002	// set/get roomnum member (pass in an osiris_path_node_info ptr)
#define PV_FLAGS		0x00000004	// set/get flags member (pass in an osiris_path_node_info ptr)
#define PV_FVEC			0x00000008	// set/get fvec member (pass in an osiris_path_node_info ptr)
#define PV_UVEC			0x00000010	// set/get uvec member (pass in an osiris_path_node_info ptr)
#define PV_ALL			0x0000001F	// set/get all members (above..pass in an osiris_path_node_info ptr)
#define PV_I_NUMNODES	0x00010000	// get number of nodes in this path
#define PV_CS_NAME		0x00020000	// get name of path
#define PV_I_NUMPATHS	0x00040000	// get number of paths (path_id & node_id are ignored in this case)

typedef struct{
	vector pos;				// where this node is in the world
	int roomnum;				// what room?
	int flags;				// if this point lives over the terrain, etc
	vector fvec;
	vector uvec;
}osiris_path_node_info;

#endif



