/*
=========================================================
THE COMPUTER CODE CONTAINED HEREIN IS THE SOLE 
PROPERTY OF OUTRAGE ENTERTAINMENT, INC. 
('OUTRAGE').  OUTRAGE, IN DISTRIBUTING THE CODE TO
END-USERS, AND SUBJECT TO ALL OF THE TERMS AND 
CONDITIONS HEREIN, GRANTS A ROYALTY-FREE, 
PERPETUAL LICENSE TO SUCH END-USERS FOR USE BY 
SUCH END-USERS IN USING, DISPLAYING,  AND 
CREATING DERIVATIVE WORKS THEREOF, SO LONG AS
SUCH USE, DISPLAY OR CREATION IS FOR NON-
COMMERCIAL, ROYALTY OR REVENUE FREE PURPOSES. 
IN NO EVENT SHALL THE END-USER USE THE 
COMPUTER CODE CONTAINED HEREIN FOR REVENUE-
BEARING PURPOSES.  THE END-USER UNDERSTANDS
AND AGREES TO THE TERMS HEREIN AND ACCEPTS THE 
SAME BY USE OF THIS FILE.
COPYRIGHT 1999 OUTRAGE ENTERTAINMENT, INC.  ALL 
RIGHTS RESERVED.
=========================================================
*/

/*
 * 
*/
#ifndef NETWORKING_H
#define NETWORKING_H

#include "pstypes.h"

#if defined(WIN32)
//Windows includes
#include <winsock.h>


#elif defined(__LINUX__)
//Linux includes/defines
#include <linux/types.h>
#include <ctype.h>
#include <errno.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <linux/ipx.h>
#include <linux/if.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <netdb.h>

#include "linux/linux_fix.h"

#define BOOL bool
#define SOCKET unsigned int
#define SOCKADDR_IN sockaddr_in
#define SOCKADDR_IPX sockaddr_ipx
#define SOCKADDR sockaddr
#define INVALID_SOCKET -1
#define NSPROTO_IPX AF_IPX
#define TRUE true
#define FALSE false
#define HOSTENT struct hostent
#define SOCKET_ERROR -1

//Winsock = sockets error translation
#define WSAEWOULDBLOCK	EWOULDBLOCK
#define WSAEINVAL			EINVAL
#define WSAENOPROTOOPT	ENOPROTOOPT


#elif defined(MACINTOSH)

#include <OpenTransport.h>
#include <OpenTptXti.h>
#include <OpenTptInternet.h>
#include "otsockets.h"

#include "macsock.h"

#define BOOL bool
#define SOCKET unsigned int
#define SOCKADDR_IN sockaddr_in
//#define SOCKADDR_IPX sockaddr_ipx
#define SOCKADDR sockaddr
//#define INVALID_SOCKET -1
//#define NSPROTO_IPX AF_IPX
#define TRUE true
#define FALSE false
#define HOSTENT struct hostent
//#define SOCKET_ERROR -1

//Winsock = sockets error translation
//#define WSAEWOULDBLOCK	EWOULDBLOCK
//#define WSAEINVAL			EINVAL
//#define WSAENOPROTOOPT	ENOPROTOOPT

extern bool Use_DirectPlay;

//#ifdef FIXED
//inline int WSAGetLastError(){return errno;}

//helper macros for working with SOCKADDR_IN to make it look nicer between windows and Linux
inline void INADDR_SET_SUN_SADDR(struct in_addr* st,unsigned int value)
{
	st->S_un.S_addr = value;
}
inline void INADDR_GET_SUN_SADDR(struct in_addr* st,unsigned int *value)
{
	*value = st->S_un.S_addr;
}
inline void INADDR_SET_SUN_SUNW(struct in_addr* st,unsigned short s_w1,unsigned short s_w2)
{
	st->S_un.S_un_w.s_w1 = s_w1;
	st->S_un.S_un_w.s_w2 = s_w2;
}
inline void INADDR_GET_SUN_SUNW(struct in_addr* st,unsigned short *s_w1,unsigned short *s_w2)
{
	*s_w1 = st->S_un.S_un_w.s_w1;
	*s_w2 = st->S_un.S_un_w.s_w2;
}
inline void INADDR_SET_SUN_SUNB(struct in_addr* st,unsigned char s_b1,unsigned char s_b2,unsigned char s_b3,unsigned char s_b4)
{
	st->S_un.S_un_b.s_b1 = s_b1;
	st->S_un.S_un_b.s_b2 = s_b2;
	st->S_un.S_un_b.s_b3 = s_b3;
	st->S_un.S_un_b.s_b4 = s_b4;
}
inline void INADDR_GET_SUN_SUNB(struct in_addr* st,unsigned char *s_b1,unsigned char *s_b2,unsigned char *s_b3,unsigned char *s_b4)
{
	*s_b1 = st->S_un.S_un_b.s_b1;
	*s_b2 = st->S_un.S_un_b.s_b2;
	*s_b3 = st->S_un.S_un_b.s_b3;
	*s_b4 = st->S_un.S_un_b.s_b4;
}
//#endif // FIXED
#endif	// OS


#define NWT_UNRELIABLE	1
#define NWT_RELIABLE	2


// This is the max size of a packet - DO NOT INCREASE THIS NUMBER ABOVE 512!
#define MAX_PACKET_SIZE	512
#if 1 //ndef DEMO
#define DEFAULT_GAME_PORT		D3_DEFAULT_PORT
#else
#define DEFAULT_GAME_PORT		6250
#endif
// Network flags
#define NF_CHECKSUM	1
#define NF_NOSEQINC	2

typedef enum
{
	NP_NONE,
	NP_TCP,
	NP_IPX,
	NP_DIRECTPLAY
} network_protocol;

typedef struct 
{
	ubyte address[6];
	ushort port;
	ubyte net_id[4];
	network_protocol connection_type;			// IPX, IP, modem, etc.
} network_address;


//This is all the reliable UDP stuff...
#define MAXNETBUFFERS			150		//Maximum network buffers (For between network and upper level functions, which is 
										//required in case of out of order packets
#define NETRETRYTIME				.75		//Time after sending before we resend
#define MIN_NET_RETRYTIME		.2
#define NETTIMEOUT				300		//Time after receiving the last packet before we drop that user
#define NETHEARTBEATTIME		10		//How often to send a heartbeat
#define MAXRELIABLESOCKETS		40		//Max reliable sockets to open at once...
#define NETBUFFERSIZE			600	//Max size of a network packet

//Network Types
#define RNT_ACK				1		//ACK Packet
#define RNT_DATA				2		//Data Packet
#define RNT_DATA_COMP		3		//Compressed Data Packet
#define RNT_REQ_CONN			4		//Requesting a connection
#define RNT_DISCONNECT		5		//Disconnecting a connection
#define RNT_HEARTBEAT		6		//Heartbeat -- send every NETHEARTBEATTIME
#define RNT_I_AM_HERE		7

//Reliable socket states
#define RNF_UNUSED			0		//Completely clean socket..
#define RNF_CONNECTED		1		//Connected and running fine
#define RNF_BROKEN			2		//Broken - disconnected abnormally
#define RNF_DISCONNECTED	3		//Disconnected cleanly
#define RNF_CONNECTING		4		//We received the connecting message, but haven't told the game yet.
#define RNF_LIMBO				5		//between connecting and connected

#define NW_AGHBN_CANCEL		1
#define NW_AGHBN_LOOKUP		2
#define NW_AGHBN_READ		3

typedef struct _async_dns_lookup
{
	unsigned int ip;	//resolved host. Write only to worker thread.
	char * host;//host name to resolve. read only to worker thread
	bool done;	//write only to the worker thread. Signals that the operation is complete
	bool error; //write only to worker thread. Thread sets this if the name doesn't resolve
	bool abort;	//read only to worker thread. If this is set, don't fill in the struct.
}async_dns_lookup;

#endif
