/*
=========================================================
THE COMPUTER CODE CONTAINED HEREIN IS THE SOLE 
PROPERTY OF OUTRAGE ENTERTAINMENT, INC. 
('OUTRAGE').  OUTRAGE, IN DISTRIBUTING THE CODE TO
END-USERS, AND SUBJECT TO ALL OF THE TERMS AND 
CONDITIONS HEREIN, GRANTS A ROYALTY-FREE, 
PERPETUAL LICENSE TO SUCH END-USERS FOR USE BY 
SUCH END-USERS IN USING, DISPLAYING,  AND 
CREATING DERIVATIVE WORKS THEREOF, SO LONG AS
SUCH USE, DISPLAY OR CREATION IS FOR NON-
COMMERCIAL, ROYALTY OR REVENUE FREE PURPOSES. 
IN NO EVENT SHALL THE END-USER USE THE 
COMPUTER CODE CONTAINED HEREIN FOR REVENUE-
BEARING PURPOSES.  THE END-USER UNDERSTANDS
AND AGREES TO THE TERMS HEREIN AND ACCEPTS THE 
SAME BY USE OF THIS FILE.
COPYRIGHT 1999 OUTRAGE ENTERTAINMENT, INC.  ALL 
RIGHTS RESERVED.
=========================================================
*/

#ifndef HUD_H
#define HUD_H


#include "pstypes.h"
#include "grdefs.h"

#define MAX_HUD_MESSAGES 3
#define HUD_MESSAGE_LENGTH 200
#define HUD_TEXT_LENGTH	32
#define DEFAULT_HUD_WIDTH		(float)FIXED_SCREEN_WIDTH
#define DEFAULT_HUD_HEIGHT		(float)FIXED_SCREEN_HEIGHT

struct object;
struct poly_model;
struct bsp_info;
struct g3Point; 

//	type to pass to functions that draw stats
typedef ushort tStatMask;

struct CFILE;

//	hud (or gauge) stat flag.
#define STAT_FPS				0x0001
#define STAT_SHIELDS			0x0002
#define STAT_ENERGY			0x0004
#define STAT_PRIMARYLOAD	0x0008
#define STAT_SECONDARYLOAD	0x0010
#define STAT_MESSAGES		0x0020
#define STAT_INVENTORY		0x0040
#define STAT_SHIP				0x0080
#define STAT_AFTERBURN		0x0100
#define STAT_WARNING			0x0200
#define STAT_GOALS			0x0400
#define STAT_TIMER			0x0800
#define STAT_CUSTOM			0x1000
#define STAT_CNTRMEASURE	0x2000
#define STAT_STANDARD		0x3ffe
#define STAT_ALL				0x3fff

// is this the special version? (defined by huddisplay.cpp or user equiv.)
#define STAT_SPECIAL			0x4000
//	is this the graphical version?
#define STAT_GRAPHICAL		0x8000

//	hud modes
typedef enum tHUDMode {

	HUD_FULLSCREEN,
	HUD_LETTERBOX,
	HUD_COCKPIT,
	HUD_OBSERVER
}
tHUDMode;

#define MAX_HUD_ITEMS			32
#define HUD_COLOR					GR_RGB(0,255,0)
#define HUD_ALPHA					192
#define HUD_ZOOM					0.56f

#define HUD_MSG_PERSISTENT_INFINITE	10000.0f
#define HUD_MSG_PERSISTENT_CENTER	-1

/////////////////////////////////////////////////////////////////////////////////

// Max characters in a hud input message
#define MAX_HUD_INPUT_LEN	80

//	number of shield frames in gauge
#define NUM_SHIELD_GAUGE_FRAMES		5
#define SHIELD_GAUGE_FRAME_FULL		0
#define SHIELD_GAUGE_FRAME_PARTIAL	1
#define SHIELD_GAUGE_FRAME_HALF		2
#define SHIELD_GAUGE_FRAME_SERIOUS	3
#define SHIELD_GAUGE_FRAME_CRITICAL	4


/////////////////////////////////////////////////////////////////////////////////

//Flags for persistent HUD messages
#define HPF_FADEOUT			1		  // message fades out when done
#define HPF_FREESPACE_DRAW	2		  // message draws with the FreeSpace briefing effect

// HUD System
	
//	predefined types (tHUDItem::type)
#define HUD_ITEM_PRIMARY		1
#define HUD_ITEM_SECONDARY		2
#define HUD_ITEM_SHIELD			3
#define HUD_ITEM_ENERGY			4
#define HUD_ITEM_AFTERBURNER	5
#define HUD_ITEM_INVENTORY		6
#define HUD_ITEM_SHIPSTATUS	7
#define HUD_ITEM_WARNINGS		8
#define HUD_ITEM_GOALS			9
#define HUD_ITEM_GOALSTATES	10
#define HUD_ITEM_CNTRMEASURE	11
#define HUD_ITEM_SCORE			12
#define HUD_ITEM_CUSTOMTEXT	20
#define HUD_ITEM_CUSTOMIMAGE	21
#define HUD_ITEM_TIMER			22
#define HUD_ITEM_CUSTOMTEXT2	23				// like custom text, keeps string pointer passed in

#define HUD_FLAG_PERSISTANT	1				// this hud item will not be resetted.
#define HUD_FLAG_SMALL			2				// when small version of hud is rendered, this will render in the AUX frame
#define HUD_FLAG_LEVEL			4				// persistent for the current level, but cleared between levels

#define HUD_INVALID_ID			255			// hud invalid id constant.

typedef struct t_dirty_rect
{
	struct
	{
		short l,t,r,b;
	}
	r[3];												// three rectangles for each frame buffer (3 max)

	void set(short l0, short t0, short r0, short b0) { r[0].l = l0; r[0].t = t0; r[0].r = r0; r[0].b = b0; };
	void reset();
	void fill(ddgr_color col);
}
tDirtyRect;											// dirty rectangle for hud item (small hud version)


typedef struct tHUDItem
{
	short x, y;
	short xa, ya;									// auxillary points
	short xb, yb;									
	short tx, ty;									// text version x and y.
	float grscalex,grscaley;					// used to scale graphics.

	ubyte id;										// id number.
	ubyte type;										// custom of predefined hud item type.
	ushort stat;									// stat mask (what class of hud items does this one belong to)

	ushort flags;									// more flags.
	ubyte alpha;									// alpha of hud item
	ubyte saturation_count;						// how saturated is this hud item (how bright).

	ddgr_color color;								// color of hud item.
	ddgr_color tcolor;							// text color of item.

	void (*render_fn)(struct tHUDItem *);	// called by hud system to draw the hud item.

	int buffer_size;								// for customtext2 item

// data is initialized depending on 'type'.
// custom types must have either element of data already initialized.
//	all predefined types can ignore this data field externally.
	union 											
	{
		int bm_handle;								// custom images
		int timer_handle;							// timer
		char *text;									// custom text.
	}
	data;

	tDirtyRect dirty_rect;						// used in small version of hud to clear only 'dirty' area
}
tHUDItem;

//	hud resources
struct sHUDResources 
{
	char hud_inf_name[PSFILENAME_LEN+1];
	int arrow_bmp;
	int goal_complete_bmp;
	int goal_bmp;
	int lock_bmp[2];
	int wpn_bmp;
	int ship_bmp;
	int energy_bmp;
	int shield_bmp[NUM_SHIELD_GAUGE_FRAMES];
	int invpulse_bmp;
	int dot_bmp;
	int afterburn_bmp;
	int antigrav_bmp[2];
};

#define HUD_ARROW_SCALE	0.20f
#define HUD_WPN_SCALE 0.75f
#define HUD_SHIP_SCALE 0.33f
#define HUD_ENERGY_SCALE 0.50f
#define HUD_SHIELD_SCALE 0.625f
#define HUD_DOT_SCALE 0.20f
#define HUD_LOCK_SCALE 0.5f
#define HUD_BURN_SCALE 0.5f

#define HUD_CLOAKEND_TIME 3.0f

//	flags for RenderHudText.
#define HUDTEXT_CENTERED 1


//////////////////////////////////////////////////////////////////////////////


#endif
